<?php
require_once "connection.php";
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$requiredParams = array(
    'userEmail', 
    'age',
    'country',
    'characterImage',
    'profession'
);
$missingParams = array();
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        $missingParams[] = $param;
    }
}

if (!empty($missingParams)) {
    echo "Error: Missing POST parameters: " . implode(', ', $missingParams);
    exit();
}

$userEmail = $_POST['userEmail'];
$age = $_POST['age'];
$country = $_POST['country'];
$characterImage = $_POST['characterImage'];
$profession = $_POST['profession'];

$stmt = $conn->prepare("UPDATE user_detail SET age = ?, country = ?, characterImage = ?, profession = ? WHERE userEmail = ?");
$stmt->bind_param("ssiss", $age, $country, $characterImage, $profession, $userEmail);

if ($stmt->execute()) {
    echo "User details updated successfully";
} else {
    echo "Error: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
