<?php
require_once "connection.php";

if (!isset($_GET['userId'])) {
    $response = array(
        'status' => 'error',
        'message' => 'User Id is required'
    );
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}
$userId = $_GET['userId'];

$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    $response = array(
        'status' => 'error',
        'message' => 'Connection failed: ' . $conn->connect_error
    );
    header('Content-Type: application/json');
    echo json_encode($response);
    exit(); 
}

$stmt = $conn->prepare("DELETE FROM messages_details WHERE userId = ?");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $response = array(
        'status' => 'success',
        'message' => 'Chats Deleted'
    );
} else {
    $response = array(
        'status' => 'error',
        'message' => 'Error deleting user data: ' . $conn->error
    );
}

$stmt->close();
$conn->close();

header('Content-Type: application/json');
echo json_encode($response);
?>
